<?php
$this->load->view('top_application');
$discount_amount = $this->session->userdata('discount_amount');
echo form_open('cart/', 'name="cart_frm" id="cart_frm" ');
?>
<div class="page_breadcrumbs">
  <div class="container">
    <ul>
      <li><a href="<?php echo site_url(); ?>">Home</a></li>
      <li>Shopping Cart</li>
    </ul>
  </div>
</div>
<section class="cart_page">
  <div class="container">
    <?php
    echo error_message();
    echo validation_message();
    $cart = $this->cart->contents();
    if (is_array($cart) && !empty($cart)) {
      ?>
      <div class="row">
        <div class="col-lg-9 col-md-9 col-sm-8  col-xs-12">
          <div class="cart_left">
            <h1>Shopping Cart</h1>
            <table>
              <thead>
                <tr>
                  <th>Product</th>
                  <th class="text-left">Unit Price </th>
                  <th class="text-center" style="    width: 175px;">QTY</th>
                  <th class="text-center">Total</th>
                  <th class="text-center">Remove</th>
                </tr>
              </thead>
              <tbody>
                <?php
                $totalAmount = $origAmount = $discountAmt = 0;
                $i = 1;
                // trace($cart);
                foreach ($cart as $items) {
                  //trace($items);
                  $sizeName = $this->config->item('sizeName');
                  $link = ($this->session->userdata('user_id') > 0) ? 'href="' . site_url() . 'cart/add_to_wishlist/' . $items['pid'] . '"' : 'href="#" data-toggle="modal" data-target="#log-modal"';
                  $pprice = ($items['discount_price'] > 0) ? $items['discount_price'] : $items['product_price'];
                  $totalAmount += $pprice * $items['qty'];
                  $origAmount += $pprice * $items['qty'];
                  $discountAmt += ($items['product_price'] - $items['discount_price']) * $items['qty'];
                  if (!is_array($items['options']['Size'])) {
                    $color_name = get_db_field_value("wps_colors", "color_name", "WHERE color_id = '" . $items['options']['Color'] . "'");
                    $size_name = get_db_field_value("wps_sizes", "size_name", "WHERE size_id = '" . $items['options']['Size'] . "'");
                  } else {
                    $size_name = 'Custom';
                    $color_name = 'As Shown';
                  }
                  //trace($color_name);
                  $url = $this->db->query("SELECT friendly_url FROM wps_products WHERE products_id = '" . $items['pid'] . "'")->row_array();
                  ?>
                  <tr>
                    <td data-label="PRODUCT">
                      <div class="cart_image">
                        <a href="<?php echo site_url($url['friendly_url']); ?>"><img src="<?php echo get_image('product_images', $items['img'], '65', '90', 'R', $url['friendly_url']); ?>"></a>
                      </div>
                      <div class="cart_info">
                        <a href="<?php echo site_url($url['friendly_url']); ?>"><?php echo $items['origname']; ?></a>

                        <strong>Code</strong>: <?php echo $items['code']; ?><br />
                        <strong>Color</strong>: <?php echo $color_name; ?> &nbsp;&nbsp;
                        <span class="custom_size"><strong>Size</strong>: <span class="custom"><?php echo $size_name; ?></span>
                          <?php
                          if (is_array($items['options']['Size'])) {
                            ?>
                            <div class="custom-hover">
                              <?php
                              foreach ($sizeName as $key => $vals) {
                                ?>
                                <p><strong><?php echo $vals; ?>: </strong><?php echo $items['options']['Size'][$key]; ?> In</p>
                                <?php
                              }
                              ?>
                            </div>
                            <?php
                          }
                          ?>
                        </span>

                      </div>
                    </td>
                    <td class="text-center" data-label="UNIT PRICE">
                      <div class="price">
                        <?php echo display_price($pprice); ?>
                      </div>
                    </td>

                    <td class="text-center" data-label="QTY">
                      <div class="details_qty">
                        <input type="button" value="" class="minus" onclick="return incDnc(2, <?php echo $i; ?>, <?php echo $items['availableqty']; ?>);" />
                        <input type="text" readonly="readonly" name="<?php echo $i; ?>[qty]" id="qty_<?php echo $i; ?>" value="<?php echo $items['qty']; ?>" class="qty qty_value" maxlength="10">
                        <input type="button" value="" class="plus" onclick="return incDnc(1, <?php echo $i; ?>, <?php echo $items['availableqty']; ?>);" />
                        <input type="hidden" name="<?php echo $i; ?>[rowid]" id='cart_rowid_<?php echo $i; ?>' value="<?php echo $items['rowid']; ?>" />
                      </div>
                    </td>
                    <td class="text-center" data-label="TOTAL">
                      <div class="price">
                        <?php echo display_price($pprice * $items['qty']); ?>
                      </div>    
                    </td>
                    <td class="text-center" data-label="REMOVE">
                      <a class="cart_remove" href="<?php echo site_url(); ?>cart/remove_item/<?php echo $items['rowid']; ?>" title="remove"><i class="fa fa-remove"></i></a>
                    </td>
                  </tr>
                  <?php
                }
                ?>

              </tbody>
            </table>
            <a class="shopping_btn" href="<?php echo site_url(); ?>product" title="Continue Shopping"><i class="fa fa-angle-left"></i> Continue Shopping</a>
            <a class="shopping_btn hidden-xs" href="<?php echo site_url(); ?>cart/empty_cart" title="Clear Shopping Cart">Clear Shopping Cart</a>
            <div class="cart_discount">
              <h4>Apply Discount Code</h4>
              <form action="">
                <?php
                if ($discount_amount > 0) {
                  ?>
                  <button class="apply_discount" id="removeCoupon" type="button">Remove Coupon</button>
                  <?php
                } else {
                  ?>
                  <input type="text" class="form-control" name="couponCode" id="couponCode" placeholder="Enter discount code" required="">
                  <button class="apply_discount" id="applyCoupon" type="button">Apply Discount</button>
                  <?php
                }
                ?>
              </form>
            </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-3 col-sm-4  col-xs-12">
          <div class="left_title">Cart Details</div>
          <div class="cart_right">
            <table class="table table-totals">
              <tbody>
                <tr>
                  <td>Price (items)</td>
                  <td>&#8377 <?php echo $totalAmount; ?></td>
                </tr>
                <?php
                if ($discount_amount > 0) {
                  ?>
                  <tr>
                    <td>Coupon discount</td>
                    <td>&#8377 <?= $discount_amount; ?></td>
                  </tr>
                  <tr>
                    <td>Total</td>
                    <td>&#8377 <?php echo ($totalAmount - $discount_amount); ?></td>
                  </tr>
                </tbody>
                <?php
              } else {
                ?>
                <tr>
                  <td>Delivery charges</td>
                  <td class="free">Free</td>
                </tr>
                <tfoot>
                  <tr>
                    <td>Total Amount</td>
                    <td>&#8377 <?php echo $totalAmount; ?></td>
                  </tr>
                </tfoot>
                <?php
              }
              ?>
            </table>
            <a class="order_btn" href="<?php echo site_url(); ?>cart/checkout" title="Place Order">Place Order</a>
            <p class="safe_info"><i class="fa fa-shield"></i> Safe and Secure Payments. Easy returns. 100% Authentic products.</p>
          </div>
        </div>

      </div>
      <?php
    } else {
      ?>
      <div class="cb"></div>
      <div class="cart_right">
        <div class="d-flex justify-content-center">
          <div class="text-center">
            <img src="<?php echo theme_url(); ?>images/shopping_cart_empty.jpg" alt="Cart Empty" title="Cart Empty">
          </div>

        </div>
      </div>
      <?php
    }
    ?>
  </div>    
</section>
<?php echo form_close(); ?>
<script src="<?php echo site_url(); ?>assets/developers/js/common.js"></script> 
<script type="text/javascript">
                          $('#applyCoupon').click(function () {
                            if ($('#couponCode').val() == '') {
                              alert('please enter valid coupon code');
                            } else {
                              $.post(site_url + 'cart/applycoupon', {couponcode: $('#couponCode').val()}, function (data) {
                                alert(data);
                                window.location.reload();
                              });
                            }
                          });
                          $('#removeCoupon').click(function () {
                            $.post(site_url + 'cart/removecoupon', {}, function (data) {
                              alert(data);
                              window.location.reload();
                            });
                          });
</script>
<?php $this->load->view('bottom_application'); ?>
